/**
 * class to represent one enum type imported from Excel file
 */
export class EnumDefinition {
	/**
	 * Constructor
	 * @param {jQuery} xmlEnumsObject 	Data loaded from XML - all enums definitions
	 * @param {String} enumName			Unique name of the predefined enam
	 */
	constructor(xmlEnumsObject, enumName) {
		var enumsMarkups = $(xmlEnumsObject).find("enum");
		this.items = Array();
		for(var i = 0; i < enumsMarkups.length; i++)
		{
			if(enumsMarkups[i].attributes.name.value == enumName) {
				for(var j = 0; j < enumsMarkups[i].children.length; j++) {
					this.items.push({"label": enumsMarkups[i].children[j].attributes.label.value, "value": Math.round(enumsMarkups[i].children[j].attributes.value.value)});
				}
				this.itemsLength = enumsMarkups[i].children.length;
			}
		}
	}

	/**
	 * Gets one pair of enum value and label by index
	 * @param {Integer} index 	Index of the searching element
	 * @returns {Collection}	Collection {label:x, value:y}
	 */
	getElByIndex(index) {
		if (index >= this.itemsLength || index < 0) {
			console.log("There is no Enum item with index: " + String(index));
			return null;
		}
		else
			return this.items[index];
	}
	
	/**
	 * Gets one pair of enum value and label by label
	 * @param {String} label 	Label of the searching element
	 * @returns {Collection}	Collection {label:x, value:y}
	 */
	getElByLabel(label) {
		var result = {};
		for(var i = 0; i < this.items.length; i++)
			if (this.items[i].label == label) {
				result = this.items[i];
				break;
			}
		return result;
	}
	
	/**
	 * Gets one pair of enum value and label by value
	 * @param {Integer} val 	Value of the searching element
	 * @returns {Collection}	Collection {label:x, value:y}
	 */
	getElByVal(val) {
		var result = {};
		for(var i = 0; i < this.items.length; i++)
			if (this.items[i].value == Math.round(val)) {
				result = this.items[i];
				break;
			}
		return result;
	}
	
	/**
	 * Gets the count of all enum items (pairs of label and value)
	 * @returns {Integer}		Number of items in the enum
	 */
	getItemsLength() {
		return this.itemsLength;
	}
	
	/**
	 * Gets label text of the enum by value
	 * @param {Integer} val 	Value of the searching element
	 * @returns {String}		Text of the label
	 */
	getLabelByVal(val) {
		var result = val;
		for(var i = 0; i < this.items.length; i++)
			if (this.items[i].value == Math.round(val)) {
				result = this.items[i].label;
				break;
			}
		return result;
	}
	
	/**
	 * Gets value of the enum by label
	 * @param {String} label 	Label text of the searching element
	 * @returns {Integer}		Value
	 */
	getValueByLabel(label) {
		var result = null;
		for(var i = 0; i < this.items.length; i++)
			if (this.items[i].label == label) {
				result = this.items[i].value;
				break;
			}
		return result;
	}
}